﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultPerformancePlugin.Controls.Strategy
{
    public interface IEnablePrefetcherStrategy
    {
        void Write(int num);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class EnablePrefetcherDefaultStrategy : ICorrespondenceOS, IEnablePrefetcherStrategy
    {
        public EnablePrefetcherDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                       
#if DEBUG
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "EnablePrefetcher";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IAdditionalWorkerThreadsStrategy メンバ

        public void Write(int num)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management\PrefetchParameters");

            registryKey.SetValue(RegName, num,RegistryValueKind.DWord);

        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management\PrefetchParameters");

            return new WFRegistry(@"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management\PrefetchParameters", "EnablePrefetcher",
                                  registryKey.GetValue(RegName, 0), RegistryValueKind.DWord, RegOperation.ValueWrite);
        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

        #endregion
    }

    public class EnablePrefetcherController
    {
        public EnablePrefetcherController(EnablePrefetcher enablePrefetcher,
                                                         IEnablePrefetcherStrategy strategy)
        {
            EnablePrefetcher = enablePrefetcher;
            Strategy = strategy;
        }

        public EnablePrefetcher EnablePrefetcher { get; set; }
        public IEnablePrefetcherStrategy Strategy { get; set; }

        public void Read()
        {
            EnablePrefetcher.SetEnablePrefetcherValue(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(EnablePrefetcher.GetEnablePrefetcherValue());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
